/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.config;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.config.ConfigRegistry;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfigSpec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.common.config.ConfigurableAction;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.utils.Orientation2D;
import slimeknights.tconstruct.world.TinkerHeadType;

public class Config {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    public static void init() {
        ConfigRegistry.registerConfig((String)"tconstruct", (ConfigType)ConfigType.COMMON, (ModConfigSpec)commonSpec);
        ConfigRegistry.registerConfig((String)"tconstruct", (ConfigType)ConfigType.CLIENT, (ModConfigSpec)clientSpec);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue tankFluidModel;
        public final ModConfigSpec.BooleanValue extraToolTips;
        public final ModConfigSpec.BooleanValue logMissingMaterialTextures;
        public final ModConfigSpec.BooleanValue logMissingModifierTextures;
        public final ModConfigSpec.BooleanValue showModifiersInJEI;
        public final ModConfigSpec.BooleanValue renderShieldSlotItem;
        public final ModConfigSpec.BooleanValue modifiersIDsInAdvancedTooltips;
        public final ModConfigSpec.IntValue maxSmelteryItemQuads;
        public final ModConfigSpec.BooleanValue renderItemFrame;
        public final ModConfigSpec.IntValue itemFrameXOffset;
        public final ModConfigSpec.IntValue itemFrameYOffset;
        public final ModConfigSpec.EnumValue<Orientation2D> itemFrameLocation;
        public final ModConfigSpec.IntValue itemsPerRow;
        public final ModConfigSpec.BooleanValue inventoryTabsCompat;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client only settings").push("client");
            this.tankFluidModel = builder.comment(new String[]{"Experimental. If true, renders fluids in tanks using a dynamic model, being more efficient when the tank is static", "If false, renders fluids in tanks using a TESR, which is more efficient when the tank contents are changing"}).translation("tconstruct.configgui.tankFluidModel").define("tankFluidModel", false);
            this.extraToolTips = builder.comment("If true tools will show additional info in their tooltips").translation("tconstruct.configgui.extraToolTips").define("extraToolTips", true);
            this.logMissingMaterialTextures = builder.comment("If true, the game will log all material textures which do not exist in resource packs but can be added, can be helpful for moddevs or resourcepack makers").translation("tconstruct.configgui.logMissingMaterialTextures").define("logMissingMaterialTextures", false);
            this.logMissingModifierTextures = builder.comment("If true, the game will log all modifier textures which do not exist in resource packs but can be added, can be helpful for moddevs or resourcepack makers").translation("tconstruct.configgui.logMissingMaterialTextures").define("logMissingModifierTextures", false);
            this.showModifiersInJEI = builder.comment("If true, modifiers will be added to the JEI ingredient list. If false, they will only be visible in the modifiers recipe tab.").translation("tconstruct.configgui.showModifiersInJEI").define("showModifiersInJEI", true);
            this.maxSmelteryItemQuads = builder.comment(new String[]{"Maximum number of quads to render for items in the smeltery. Most blocks are about 6 quads, items like ingots are around 26.", "Setting this lower will cause fewer items to be renderer (but never a partial item). Set to -1 to allow unlimited quads, and 0 to disable the item renderer."}).defineInRange("maxSmelteryItemQuads", 3500, -1, Short.MAX_VALUE);
            this.modifiersIDsInAdvancedTooltips = builder.comment(new String[]{"If true, shows modifier IDs in advanced tooltips for tools and tool parts.", "They are more intrusive than most advanced tooltip content, so this option is provided in case some mod made poor design decisions and put essential gameplay info in tooltips or for pack makers who do not need modifier info."}).define("modifiersIDsInAdvancedTooltips", true);
            builder.comment("Settings related to modifiers").push("modifiers");
            this.renderShieldSlotItem = builder.comment("If true, the shield slot legging modifier will render the next offhand item above the offhand slot.").define("renderShieldSlotItem", true);
            builder.comment("Settings related to the frame helmet modifier").push("itemFrame");
            this.renderItemFrame = builder.comment("If true, the item frame modifier for helmets will render its items. Turning this to false makes the modifier useless.").define("render", true);
            this.itemFrameXOffset = builder.comment("Offset in the X direction for the frame items.").defineInRange("xOffset", 0, Short.MIN_VALUE, Short.MAX_VALUE);
            this.itemFrameYOffset = builder.comment("Offset in the Y direction for the frame items.").defineInRange("yOffset", 0, Short.MIN_VALUE, Short.MAX_VALUE);
            this.itemFrameLocation = builder.comment("Location of the frame on the screen.").defineEnum("location", (Enum)Orientation2D.TOP_LEFT);
            this.itemsPerRow = builder.comment("Number of items to display in each row of the item frame.").defineInRange("itemsPerRow", 5, 0, 100);
            builder.pop();
            builder.pop();
            builder.comment("Settings related to compatibility").push("compatibility");
            this.inventoryTabsCompat = builder.comment("If true and Inventory Tabs is loaded, TConstruct table tabs will be hidden so Inventory Tabs tabs can be used.").define("inventoryTabs", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue shouldSpawnWithTinkersBook;
        public final List<ConfigurableAction> damageSourceTweaks;
        public final ModConfigSpec.BooleanValue addGravelToFlintRecipe;
        public final ModConfigSpec.BooleanValue cheaperNetheriteAlloy;
        public final ModConfigSpec.BooleanValue witherBoneDrop;
        public final ModConfigSpec.BooleanValue witherBoneConversion;
        public final ModConfigSpec.BooleanValue slimeRecipeFix;
        public final ModConfigSpec.BooleanValue glassRecipeFix;
        public final Map<TinkerHeadType, ModConfigSpec.BooleanValue> headDrops;
        public final ModConfigSpec.DoubleValue repairKitAmount;
        public final ModConfigSpec.BooleanValue slimyLootChests;
        public final ModConfigSpec.IntValue barterBlazingBlood;
        public final ModConfigSpec.IntValue tinkerToolBonusChest;
        public final ModConfigSpec.BooleanValue dropDragonScales;
        public final OreRate melterOreRate;
        public final OreRate smelteryOreRate;
        public final OreRate foundryOreRate;
        public final OreRate foundryByproductRate;
        public final ModConfigSpec.BooleanValue generateCobalt;
        public final ModConfigSpec.ConfigValue<Integer> veinCountCobalt;
        public final ModConfigSpec.BooleanValue forceGeodeRecipes;
        public final ModConfigSpec.BooleanValue earthGeodes;
        public final ModConfigSpec.BooleanValue skyGeodes;
        public final ModConfigSpec.BooleanValue ichorGeodes;
        public final ModConfigSpec.BooleanValue enderGeodes;
        public final ModConfigSpec.ConfigValue<String> showOnlyToolMaterial;
        public final ModConfigSpec.ConfigValue<String> showOnlyPartMaterial;
        public final ModConfigSpec.BooleanValue showAllTableVariants;
        public final ModConfigSpec.BooleanValue showAllAnvilVariants;
        public final ModConfigSpec.BooleanValue showAllSmelteryVariants;
        public final ModConfigSpec.BooleanValue forceIntegrationMaterials;
        public final ModConfigSpec.EnumValue<LogInvalidToolStack> logInvalidToolStack;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Everything to do with gameplay").push("gameplay");
            this.shouldSpawnWithTinkersBook = builder.comment("Set this to false to disable new players spawning with the Tinkers' Book.").translation("tconstruct.configgui.shouldSpawnWithTinkersBook").worldRestart().define("shouldSpawnWithTinkersBook", true);
            builder.comment("Tweaks to vanilla damage sources to better work with armor").push("damageTweaks");
            ImmutableList.Builder actions = ImmutableList.builder();
            this.damageSourceTweaks = actions.build();
            this.repairKitAmount = builder.comment("Amount of durability restored by a repair kit in terms of ingots. Does not affect the cost to create the kit, that is controlled by JSON.").defineInRange("repairKitAmount", 2.0, 0.0, 32767.0);
            builder.pop();
            this.showOnlyToolMaterial = builder.comment(new String[]{"If non-empty, only this material will be shown on tools in creative and JEI (or the first valid material if this is invalid for the tool).", "If empty, all materials will show"}).translation("tconstruct.configgui.showOnlyToolMaterial").worldRestart().define("showOnlyToolMaterial", (Object)"");
            this.showOnlyPartMaterial = builder.comment(new String[]{"If non-empty, only material will be shown on parts in creative and JEI (or the first valid material if this is invalid for the part).", "If empty, all materials will show"}).translation("tconstruct.configgui.showOnlyPartMaterial").worldRestart().define("showOnlyPartMaterial", (Object)"");
            this.showAllTableVariants = builder.comment("If true, tables such as the part builder and tinker station will show all variants. If false shows only a variant with a default texture.").translation("tconstruct.configgui.showAllTableVariants").define("showAllTableVariants", true);
            this.showAllAnvilVariants = builder.comment("If true, anvils will show all metal variants. If false, shows only a variant with the default texture").translation("tconstruct.configgui.showAllAnvilVariants").define("showAllAnvilVariants", true);
            this.showAllSmelteryVariants = builder.comment("If true, smeltery and foundry controllers, drains, ducts, and chutes will show all variants").translation("tconstruct.configgui.showAllSmelteryVariants").define("showAllSmelteryVariants", true);
            builder.pop();
            builder.comment("Options related to recipes, limited options as a datapack allows most recipes to be modified").push("recipes");
            this.addGravelToFlintRecipe = builder.comment("Add a recipe that allows you to craft a piece of flint using 3 gravel").translation("tconstruct.configgui.addGravelToFlintRecipe").worldRestart().define("addGravelToFlintRecipe", true);
            this.cheaperNetheriteAlloy = builder.comment("Makes the recipe to alloy netherite in the smeltery only cost 2 gold per netherite ingot. If false uses the vanilla rate of 4 gold per ingot. Disable if there are crafting duplications.").translation("tconstruct.configgui.cheaperNetheriteAlloy").worldRestart().define("cheaperNetheriteAlloy", true);
            this.witherBoneDrop = builder.comment("Makes wither skeletons drop necrotic bones").translation("tconstruct.configgui.witherBoneDrop").worldRestart().define("witherBoneDrop", true);
            this.witherBoneConversion = builder.comment("Allows converting wither bones to regular bones").translation("tconstruct.configgui.witherBoneConversion").worldRestart().define("witherBoneConversion", true);
            this.slimeRecipeFix = builder.comment("Slimeballs not being usable in vanilla recipes that require slimeballs. Config option exists to disable easily in case this fix is redundant to another mod").worldRestart().define("slimeRecipeFix", true);
            this.glassRecipeFix = builder.comment("Fixes clear glass not being usable in vanilla recipes that require glass. Config option exists to disable easily in case this fix is redundant to another mod").translation("tconstruct.configgui.glassRecipeFix").worldRestart().define("glassRecipeFix", true);
            builder.push("ore_rates");
            builder.comment("Ore rates when melting in the melter").push("melter");
            this.melterOreRate = new OreRate(builder, 12, 8);
            builder.pop();
            builder.comment("Ore rates when melting in the smeltery").push("smeltery");
            this.smelteryOreRate = new OreRate(builder, 12, 8);
            builder.pop();
            builder.comment("Ore rates when melting in the foundry").push("foundry");
            this.foundryOreRate = new OreRate(builder, 9, 4);
            builder.pop();
            builder.comment("Byprouct rates when melting in the foundry").push("foundry_byproduct");
            this.foundryByproductRate = new OreRate(builder, 3, 4);
            builder.pop();
            builder.pop();
            builder.comment("Entity head drops when killed by a charged creeper").push("heads");
            this.headDrops = new EnumMap<TinkerHeadType, ModConfigSpec.BooleanValue>(TinkerHeadType.class);
            for (TinkerHeadType headType : TinkerHeadType.values()) {
                this.headDrops.put(headType, builder.translation("tconstruct.configgui.heads." + headType.method_15434()).define(headType.method_15434(), true));
            }
            builder.pop(2);
            builder.comment(new String[]{"Options related to loot table injections. Note some of the changes are done via global loot managers, these only control injecting loot into loot pools", "If your modpack makes extensive loot table changes, many of these may be automatically disabled. You can also manually set up tables for more control."}).push("loot");
            this.slimyLootChests = builder.comment("Adds slimy saplings and seeds into various loot chests. Helps for worlds without slime islands").worldRestart().define("slimy_loot", true);
            this.barterBlazingBlood = builder.comment("Weight of blazing blood in the piglin bartering tables. Set to 0 to disable").worldRestart().defineInRange("barter_blazing_blood", 20, 0, 100);
            this.tinkerToolBonusChest = builder.comment(new String[]{"Weight of tinker tools in the vanilla spawn bonus chest, randomly replacing the vanilla axe or shovel. Tool will have a random tier 1 head and binding, plus a wooden handle. Set to 0 to disable.", "For comparison, vanilla wooden axes and pickaxes have a weight of 3, and stone axes/pickaxes have a weight of 1"}).worldRestart().defineInRange("tinker_tool_bonus_chest", 2, 0, 25);
            this.dropDragonScales = builder.comment("If true, ender dragons will drop scales when damaged by explosions").define("drop_dragon_Scales", true);
            builder.pop();
            builder.comment("Everything to do with world generation").push("worldgen");
            this.generateCobalt = builder.comment("Generate Cobalt").translation("tconstruct.configgui.generateCobalt").worldRestart().define("generateCobalt", true);
            this.veinCountCobalt = builder.comment("Approx Ores per Chunk").translation("tconstruct.configgui.veinCountCobalt").worldRestart().define("veinCountCobalt", (Object)8);
            builder.comment("Options related to slime geodes").push("geodes");
            this.forceGeodeRecipes = builder.comment("If true, recipes using slime crystals will ignore the other geode configs, useful if you add other ways to get the slime crystals. When false (default), recipes using slime crystals will be substituted for an alternative if the geode is disabled.").define("forceRecipes", false);
            this.earthGeodes = builder.comment("If true, earthslime geodes generate deep in the world as another way to get slime").define("earth", true);
            this.skyGeodes = builder.comment("If true, skyslime geodes generate above amethyst as another way to get skyslime").define("sky", true);
            this.ichorGeodes = builder.comment("If true, ichor geodes generate high in the nether. Strongly encouraged to keep enabled even if you disable the other geodes, as ichor crystals have some unique recipes and the fallbacks kinda suck for gameplay.").define("ichor", true);
            this.enderGeodes = builder.comment("If true, enderslime geodes generate as additional islands in the end").define("ender", true);
            builder.pop();
            builder.pop();
            builder.comment("Features to use in debugging gameplay and mechanics, generally should not be enabled in packs").push("debug");
            this.forceIntegrationMaterials = builder.comment(new String[]{"If true, forces integration materials to be enabled, even if the relevant metal is missing. Useful for testing material balance.", "Does not provide recipes for any of them, they will only be available to cheat in creative."}).worldRestart().define("forceIntegrationMaterials", false);
            this.logInvalidToolStack = builder.comment("If STACKTRACE, logs the stacktrace whenever a tool stack is created from a non-modifiable item. If WARNING (default), logs a shorter but more efficient error. If IGNORE, disables logging (useful for modpacks/players *after* they reported the issue). The stacktrace helps debug which mod is causing it, but is rather expensive on the chance they are doing it a lot.").defineEnum("logInvalidToolStack", (Enum)LogInvalidToolStack.WARNING);
            builder.pop();
        }

        public static enum LogInvalidToolStack {
            STACKTRACE,
            WARNING,
            IGNORED;

        }
    }

    public static class OreRate
    implements IMeltingContainer.IOreRate {
        private final ModConfigSpec.ConfigValue<Integer> nuggetsPerMetal;
        private final ModConfigSpec.ConfigValue<Integer> shardsPerGem;

        public OreRate(ModConfigSpec.Builder builder, int defaultNuggets, int defaultQuarters) {
            this.nuggetsPerMetal = builder.comment("Number of nuggets produced per metal ore unit melted. 9 nuggets would give 1 ingot").defineInRange("nuggetsPerMetal", defaultNuggets, 1, 45);
            this.shardsPerGem = builder.comment("Number of gem shards produced per gem ore unit melted. 4 gem shards would give 1 gem").defineInRange("shardsPerGem", defaultQuarters, 1, 20);
        }

        @Override
        public long applyOreBoost(IMeltingContainer.OreRateType rate, long amount) {
            return switch (rate) {
                default -> throw new IncompatibleClassChangeError();
                case IMeltingContainer.OreRateType.METAL -> amount * (long)((Integer)this.nuggetsPerMetal.get()).intValue() / 9L;
                case IMeltingContainer.OreRateType.GEM -> amount * (long)((Integer)this.shardsPerGem.get()).intValue() / 4L;
            };
        }
    }
}

